<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

require_once __DIR__ . '/vendor/autoload.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

try {
    // Get HTML content from POST request
    $content = file_get_contents('php://input');
    $data = json_decode($content, true);
    
    if (!isset($data['html'])) {
        throw new Exception('HTML content is required');
    }

    $html = $data['html'];

    // Generate unique filename using timestamp and random number
    $timestamp = date('Y-m-d_H-i-s');
    $random = mt_rand(1000, 9999);
    $filename = "invoice_{$timestamp}_{$random}.pdf";
    
    // Create pdfs directory if it doesn't exist
    $pdfDir = __DIR__ . '/pdfs';
    if (!file_exists($pdfDir)) {
        mkdir($pdfDir, 0777, true);
    }

    $pdfPath = $pdfDir . '/' . $filename;

    // Configure mPDF
    $mpdf = new \Mpdf\Mpdf([
        'mode' => 'utf-8',
        'format' => 'A4',
        'margin_left' => 10,
        'margin_right' => 10,
        'margin_top' => 10,
        'margin_bottom' => 10,
        'tempDir' => __DIR__ . '/tmp'
    ]);

    // Set RTL mode
    $mpdf->SetDirectionality('rtl');

    // Write HTML content
    $mpdf->WriteHTML($html);

    // Save PDF to file
    $mpdf->Output($pdfPath, 'F');

    // Generate direct URL to PDF
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    $baseUrl = $protocol . '://' . $host;
    $currentDir = dirname($_SERVER['PHP_SELF']);
    $pdfUrl = $baseUrl . $currentDir . '/pdfs/' . $filename;

    // Return success response with PDF URL
    http_response_code(200);
    echo json_encode([
        'status' => 200,
        'message' => 'تم تحويل الملف بنجاح',
        'pdf_url' => $pdfUrl
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'status' => 500,
        'message' => $e->getMessage()
    ]);
}
